-- MySQL Administrator dump 1.4
--
-- ------------------------------------------------------
-- Server version	5.7.18


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


--
-- Create schema vacaciones
--

-- CREATE DATABASE IF NOT EXISTS vacaciones;
-- USE vacaciones;

--
-- Definition of table `festivos`
--

DROP TABLE IF EXISTS `festivos`;
CREATE TABLE `festivos` (
  `idfestivos` int(11) NOT NULL AUTO_INCREMENT,
  `DiaFiesta` date NOT NULL,
  `Titulo` varchar(100) COLLATE utf8_spanish_ci DEFAULT NULL,
  PRIMARY KEY (`idfestivos`),
  UNIQUE KEY `DiaFiesta_UNIQUE` (`DiaFiesta`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;

--
-- Dumping data for table `festivos`
--

/*!40000 ALTER TABLE `festivos` DISABLE KEYS */;
INSERT INTO `festivos` (`idfestivos`,`DiaFiesta`,`Titulo`) VALUES 
 (1,'2018-01-01','Año Nuevo'),
 (2,'2018-01-08','Reyes'),
 (7,'2023-01-06',''),
 (8,'2023-03-20',''),
 (9,'2023-04-06',''),
 (10,'2023-05-01',''),
 (11,'2023-04-07',''),
 (12,'2023-05-02',''),
 (13,'2023-08-15',''),
 (14,'2023-10-12',''),
 (15,'2023-11-01',''),
 (16,'2023-12-06',''),
 (17,'2023-12-08',''),
 (18,'2023-12-25',''),
 (19,'2022-04-14',''),
 (20,'2022-01-06',''),
 (21,'2022-04-15',''),
 (22,'2022-05-02',''),
 (23,'2022-07-25',''),
 (24,'2022-08-15',''),
 (25,'2022-10-12',''),
 (26,'2022-11-01',''),
 (27,'2022-12-06',''),
 (28,'2022-12-08',''),
 (29,'2022-12-26','');
/*!40000 ALTER TABLE `festivos` ENABLE KEYS */;


--
-- Definition of table `grupo_trabajo`
--

DROP TABLE IF EXISTS `grupo_trabajo`;
CREATE TABLE `grupo_trabajo` (
  `idgrupo_trabajo` int(11) NOT NULL AUTO_INCREMENT,
  `Titulo` varchar(40) COLLATE utf8_spanish_ci NOT NULL,
  `Descripcion` varchar(300) COLLATE utf8_spanish_ci DEFAULT NULL,
  `Color` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  PRIMARY KEY (`idgrupo_trabajo`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;

--
-- Dumping data for table `grupo_trabajo`
--

/*!40000 ALTER TABLE `grupo_trabajo` DISABLE KEYS */;
INSERT INTO `grupo_trabajo` (`idgrupo_trabajo`,`Titulo`,`Descripcion`,`Color`) VALUES 
 (1,'DITD','Dirección de Innovación y Transformación Digital','#67E06D'),
 (2,'Proy. PEMD','Proyecto PEMD','#88C5E3');
/*!40000 ALTER TABLE `grupo_trabajo` ENABLE KEYS */;


--
-- Definition of table `periodo`
--

DROP TABLE IF EXISTS `periodo`;
CREATE TABLE `periodo` (
  `idperiodo` int(11) NOT NULL AUTO_INCREMENT,
  `Titulo` varchar(50) COLLATE utf8_spanish_ci NOT NULL,
  `Descripcion` varchar(300) COLLATE utf8_spanish_ci DEFAULT NULL,
  `FechaInicio` date NOT NULL,
  `FechaFin` date NOT NULL,
  `Abierto` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idperiodo`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;

--
-- Dumping data for table `periodo`
--

/*!40000 ALTER TABLE `periodo` DISABLE KEYS */;
INSERT INTO `periodo` (`idperiodo`,`Titulo`,`Descripcion`,`FechaInicio`,`FechaFin`,`Abierto`) VALUES 
 (1,'Navidades 2017','Fiestas de Navidades','2017-12-11','2018-02-15',0),
 (2,'Semana Santa 2018','Semana Santa 2018 ............................','2018-03-01','2018-04-15',0),
 (3,'año 2023','Todo el año 2023','2023-01-01','2023-12-31',1);
/*!40000 ALTER TABLE `periodo` ENABLE KEYS */;


--
-- Definition of table `peticion`
--

DROP TABLE IF EXISTS `peticion`;
CREATE TABLE `peticion` (
  `idpeticion` int(11) NOT NULL AUTO_INCREMENT,
  `usuario_idusuario` int(11) NOT NULL,
  `periodo_idperiodo` int(11) NOT NULL,
  `FechaInicio` date NOT NULL,
  `FechaFin` date NOT NULL,
  `DiasNaturales` int(11) DEFAULT '0',
  `DiasLaborables` int(11) DEFAULT '0',
  `DiasFinSemana` int(11) DEFAULT '0',
  `DiasFiesta` int(11) DEFAULT '0',
  `Status` varchar(1) COLLATE utf8_spanish_ci NOT NULL DEFAULT '0' COMMENT '0 = Pendiente\n1 = Aprobado',
  PRIMARY KEY (`idpeticion`),
  KEY `fk_peticion_usuario1_idx` (`usuario_idusuario`),
  KEY `fk_peticion_periodo1_idx` (`periodo_idperiodo`),
  CONSTRAINT `fk_peticion_periodo1` FOREIGN KEY (`periodo_idperiodo`) REFERENCES `periodo` (`idperiodo`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_peticion_usuario1` FOREIGN KEY (`usuario_idusuario`) REFERENCES `usuario` (`idusuario`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;

--
-- Dumping data for table `peticion`
--

/*!40000 ALTER TABLE `peticion` DISABLE KEYS */;
INSERT INTO `peticion` (`idpeticion`,`usuario_idusuario`,`periodo_idperiodo`,`FechaInicio`,`FechaFin`,`DiasNaturales`,`DiasLaborables`,`DiasFinSemana`,`DiasFiesta`,`Status`) VALUES 
 (1,1,1,'2017-12-19','2017-12-30',12,9,3,0,'0'),
 (4,1,1,'2018-01-03','2018-01-10',8,5,2,1,'0'),
 (5,1,1,'2018-02-01','2018-02-06',6,4,2,0,'0'),
 (6,2,1,'2018-02-01','2018-02-08',7,6,1,0,'0'),
 (7,2,1,'2018-01-01','2018-01-10',9,6,1,2,'0'),
 (8,1,1,'2017-12-11','2017-12-12',2,2,0,0,'0'),
 (9,1,3,'2023-04-21','2023-05-03',12,9,3,0,'1'),
 (10,2,3,'2023-04-19','2023-05-09',21,15,6,0,'0');
/*!40000 ALTER TABLE `peticion` ENABLE KEYS */;


--
-- Definition of table `usuario`
--

DROP TABLE IF EXISTS `usuario`;
CREATE TABLE `usuario` (
  `idusuario` int(11) NOT NULL AUTO_INCREMENT,
  `Login` varchar(16) COLLATE utf8_spanish_ci NOT NULL,
  `NombreyApellido` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `Password` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `Color` varchar(10) COLLATE utf8_spanish_ci NOT NULL DEFAULT '#000000',
  `UsuarioUltModificacion` varchar(16) COLLATE utf8_spanish_ci NOT NULL,
  `FechaUltModificacion` date NOT NULL,
  `Jefe_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`idusuario`),
  KEY `fk_usuario_usuario1_idx` (`Jefe_id`),
  CONSTRAINT `fk_usuario_usuario1` FOREIGN KEY (`Jefe_id`) REFERENCES `usuario` (`idusuario`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;

--
-- Dumping data for table `usuario`
--

/*!40000 ALTER TABLE `usuario` DISABLE KEYS */;
INSERT INTO `usuario` (`idusuario`,`Login`,`NombreyApellido`,`Password`,`Color`,`UsuarioUltModificacion`,`FechaUltModificacion`,`Jefe_id`) VALUES 
 (1,'admin','Fernando Humanes','21232f297a57a5a743894a0e4a801fc3','#DE57F0','admin','2023-04-21',1),
 (2,'humanes','Fernando Humanes Pereira','1e63dafa7e63f073ed2f362a49f8cf24','#70DBD4','admin','2023-04-21',1);
/*!40000 ALTER TABLE `usuario` ENABLE KEYS */;


--
-- Definition of table `usuario_grupo`
--

DROP TABLE IF EXISTS `usuario_grupo`;
CREATE TABLE `usuario_grupo` (
  `idusuario_grupo` int(11) NOT NULL AUTO_INCREMENT,
  `usuario_idusuario` int(11) NOT NULL,
  `grupo_trabajo_idgrupo_trabajo` int(11) NOT NULL,
  PRIMARY KEY (`idusuario_grupo`),
  KEY `fk_usuario_grupo_usuario_idx` (`usuario_idusuario`),
  KEY `fk_usuario_grupo_grupo_trabajo1_idx` (`grupo_trabajo_idgrupo_trabajo`),
  CONSTRAINT `fk_usuario_grupo_grupo_trabajo1` FOREIGN KEY (`grupo_trabajo_idgrupo_trabajo`) REFERENCES `grupo_trabajo` (`idgrupo_trabajo`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_usuario_grupo_usuario` FOREIGN KEY (`usuario_idusuario`) REFERENCES `usuario` (`idusuario`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;

--
-- Dumping data for table `usuario_grupo`
--

/*!40000 ALTER TABLE `usuario_grupo` DISABLE KEYS */;
INSERT INTO `usuario_grupo` (`idusuario_grupo`,`usuario_idusuario`,`grupo_trabajo_idgrupo_trabajo`) VALUES 
 (1,1,1),
 (3,2,1),
 (4,1,2);
/*!40000 ALTER TABLE `usuario_grupo` ENABLE KEYS */;


--
-- Definition of table `vacaciones_audit`
--

DROP TABLE IF EXISTS `vacaciones_audit`;
CREATE TABLE `vacaciones_audit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `datetime` datetime NOT NULL,
  `ip` varchar(40) NOT NULL,
  `user` varchar(300) DEFAULT NULL,
  `table` varchar(300) DEFAULT NULL,
  `action` varchar(250) NOT NULL,
  `description` mediumtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=183 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `vacaciones_audit`
--

/*!40000 ALTER TABLE `vacaciones_audit` DISABLE KEYS */;
INSERT INTO `vacaciones_audit` (`id`,`datetime`,`ip`,`user`,`table`,`action`,`description`) VALUES 
 (1,'2018-02-21 13:24:53','::1','admin','festivos','add','---Keys\r\nidfestivos : 1\r\n---Fields\r\nDiaFiesta [new]: 2018-01-01\r\nTitulo [new]: Año Nuewvo\r\n'),
 (2,'2018-02-21 13:25:05','::1','admin','festivos','edit','---Keys\r\nidfestivos : 1\r\n---Fields\r\nTitulo [old]: Año Nuewvo\r\nTitulo [new]: Año Nuevo\r\n'),
 (3,'2018-02-21 13:32:01','::1','admin','festivos','add','---Keys\r\nidfestivos : 2\r\n---Fields\r\nDiaFiesta [new]: 2018-01-06 00:00:00\r\nTitulo [new]: Reyes\r\n'),
 (4,'2018-02-21 13:44:21','::1','admin','usuario','edit','---Keys\r\nidusuario : 1\r\n---Fields\r\nColor [old]: #FFFFFF\r\nColor [new]: #1C31C9\r\nUsuarioUltModificacion [old]: humanes\r\nUsuarioUltModificacion [new]: admin\r\nFechaUltModificacion [old]: 2018-02-21 00:00:00\r\nFechaUltModificacion [new]: 2018-02-21 13:44:21\r\n'),
 (5,'2018-02-21 13:57:18','::1','admin','grupo_trabajo','add','---Keys\r\nidgrupo_trabajo : 1\r\n---Fields\r\nTitulo [new]: DITD\r\nDescripcion [new]: Dirección de Innovación y Transformación Digital\r\nColor [new]: #000000\r\n'),
 (6,'2018-02-21 14:00:55','::1','admin','grupo_trabajo','add','---Keys\r\nidgrupo_trabajo : 2\r\n---Fields\r\nTitulo [new]: Proy. PEMD\r\nDescripcion [new]: Proyecto PEMD\r\nColor [new]: #51EB46\r\n'),
 (7,'2018-02-21 14:06:55','::1','admin','usuario_grupo','add','---Keys\r\nidusuario_grupo : 1\r\n---Fields\r\nusuario_idusuario [new]: 1\r\ngrupo_trabajo_idgrupo_trabajo [new]: 1\r\n'),
 (8,'2018-02-21 14:14:24','::1','admin','usuario','add','---Keys\r\nidusuario : 2\r\n---Fields\r\nLogin [new]: humanes\r\nNombreyApellido [new]: Fernando Humanes Pereira\r\nPassword [new]: humanes\r\nColor [new]: #71DE0B\r\nUsuarioUltModificacion [new]: admin\r\nFechaUltModificacion [new]: 2018-02-21 14:14:01\r\n'),
 (9,'2018-02-21 14:18:42','::1','admin','usuario_grupo','add','---Keys\r\nidusuario_grupo : 2\r\n---Fields\r\nusuario_idusuario [new]: 1\r\ngrupo_trabajo_idgrupo_trabajo [new]: 2\r\n'),
 (10,'2018-02-21 14:19:08','::1','admin','usuario_grupo','add','---Keys\r\nidusuario_grupo : 3\r\n---Fields\r\nusuario_idusuario [new]: 2\r\ngrupo_trabajo_idgrupo_trabajo [new]: 1\r\n'),
 (11,'2018-02-21 14:21:21','::1','admin','usuario_grupo','add','---Keys\r\nidusuario_grupo : 4\r\n---Fields\r\nusuario_idusuario [new]: 1\r\ngrupo_trabajo_idgrupo_trabajo [new]: 2\r\n'),
 (12,'2018-02-21 14:21:27','::1','admin','usuario_grupo','delete','---Keys\r\nidusuario_grupo : 4\r\n---Fields\r\nusuario_idusuario [old]: 1\r\ngrupo_trabajo_idgrupo_trabajo [old]: 2\r\n'),
 (13,'2018-02-21 14:28:04','::1','admin','periodo','add','---Keys\r\nidperiodo : 1\r\n---Fields\r\nTitulo [new]: Navidades 2017\r\nDescripcion [new]: Fiestas de Navidades\r\nFechaInicio [new]: 2017-12-01 00:00:00\r\nFechaFin [new]: 2018-01-21 00:00:00\r\nAbierto [new]: 1\r\n'),
 (14,'2018-02-21 14:47:06','::1','admin','peticion','add','---Keys\r\nidpeticion : 1\r\n---Fields\r\nusuario_idusuario [new]: 1\r\nperiodo_idperiodo [new]: 1\r\nFechaInicio [new]: 2017-12-19 00:00:00\r\nFechaFin [new]: 2017-12-30 00:00:00\r\n'),
 (15,'2018-02-21 16:39:52','::1','admin','usuario_grupo','delete','---Keys\r\nidusuario_grupo : 2\r\n---Fields\r\nusuario_idusuario [old]: 1\r\ngrupo_trabajo_idgrupo_trabajo [old]: 2\r\n'),
 (16,'2018-02-21 16:41:19','::1','admin','periodo','add','---Keys\r\nidperiodo : 2\r\n---Fields\r\nTitulo [new]: Semana Santa 2018\r\nDescripcion [new]: Semana Santa 2018 ............................\r\nFechaInicio [new]: 2018-03-01 00:00:00\r\nFechaFin [new]: 2018-04-15 00:00:00\r\n'),
 (17,'2018-02-21 16:52:07','::1','admin','usuario','edit','---Keys\r\nidusuario : 1\r\n---Fields\r\nPassword [old]: humanes\r\nPassword [new]: 3c4d23b8250c22870117ad0fcb2aeced\r\nFechaUltModificacion [old]: 2018-02-21 00:00:00\r\nFechaUltModificacion [new]: 2018-02-21 16:52:07\r\n'),
 (18,'2018-02-21 16:52:18','::1','admin','usuario','edit','---Keys\r\nidusuario : 1\r\n---Fields\r\nPassword [old]: 3c4d23b8250c22870117ad0fcb2aeced\r\nPassword [new]: 1e63dafa7e63f073ed2f362a49f8cf24\r\nFechaUltModificacion [old]: 2018-02-21 00:00:00\r\nFechaUltModificacion [new]: 2018-02-21 16:52:18\r\n'),
 (19,'2018-02-21 16:52:28','::1','admin','usuario','edit','---Keys\r\nidusuario : 2\r\n---Fields\r\nPassword [old]: humanes\r\nPassword [new]: 3c4d23b8250c22870117ad0fcb2aeced\r\nFechaUltModificacion [old]: 2018-02-21 00:00:00\r\nFechaUltModificacion [new]: 2018-02-21 16:52:28\r\n'),
 (20,'2018-02-21 16:52:35','::1','admin','usuario','edit','---Keys\r\nidusuario : 2\r\n---Fields\r\nPassword [old]: 3c4d23b8250c22870117ad0fcb2aeced\r\nPassword [new]: 1e63dafa7e63f073ed2f362a49f8cf24\r\nFechaUltModificacion [old]: 2018-02-21 00:00:00\r\nFechaUltModificacion [new]: 2018-02-21 16:52:35\r\n'),
 (21,'2018-02-22 16:57:30','::1','admin','peticion','add','---Keys\r\nidpeticion : 2\r\n---Fields\r\nusuario_idusuario [new]: 1\r\nperiodo_idperiodo [new]: 1\r\nFechaInicio [new]: 2018-02-14 00:00:00\r\nFechaFin [new]: 2018-02-27 00:00:00\r\n'),
 (22,'2018-02-22 16:57:45','::1','admin','peticion','delete','---Keys\r\nidpeticion : 2\r\n---Fields\r\nusuario_idusuario [old]: 1\r\nperiodo_idperiodo [old]: 1\r\nFechaInicio [old]: 2018-02-14\r\nFechaFin [old]: 2018-02-27\r\nDiasNaturales [old]: 0\r\nDiasFinSemana [old]: 0\r\nDiasFiesta [old]: 0\r\n'),
 (23,'2018-02-22 17:10:34','::1','admin','user_peticion','add','---Keys\r\nidpeticion : 3\r\n---Fields\r\nusuario_idusuario [new]: 1\r\nperiodo_idperiodo [new]: 1\r\nFechaInicio [new]: 2018-02-06 00:00:00\r\nFechaFin [new]: 2018-02-27 00:00:00\r\n'),
 (24,'2018-02-22 17:10:56','::1','admin','user_peticion','delete','---Keys\r\nidpeticion : 3\r\n---Fields\r\nusuario_idusuario [old]: 1\r\nperiodo_idperiodo [old]: 1\r\nFechaInicio [old]: 2018-02-06\r\nFechaFin [old]: 2018-02-27\r\n'),
 (25,'2018-02-22 17:48:00','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n---Fields\r\nPassword [old]: 1e63dafa7e63f073ed2f362a49f8cf24\r\nPassword [new]: d41d8cd98f00b204e9800998ecf8427e\r\n'),
 (26,'2018-02-24 13:42:50','::1','admin','usuario','edit','---Keys\r\nidusuario : 1\r\n---Fields\r\nColor [old]: #1C31C9\r\nColor [new]: #C91C5C\r\nFechaUltModificacion [old]: 2018-02-21 00:00:00\r\nFechaUltModificacion [new]: 2018-02-24 13:42:50\r\n'),
 (27,'2018-02-24 13:45:32','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (28,'2018-02-24 18:09:23','::1','admin','user_peticion','add','---Keys\r\nidpeticion : 4\r\n---Fields\r\nusuario_idusuario [new]: 1\r\nperiodo_idperiodo [new]: 1\r\nFechaInicio [new]: 2018-01-03 00:00:00\r\nFechaFin [new]: 2018-01-10 00:00:00\r\n'),
 (29,'2018-02-24 18:13:06','::1','admin','user_peticion','add','---Keys\r\nidpeticion : 5\r\n---Fields\r\nusuario_idusuario [new]: 1\r\nperiodo_idperiodo [new]: 1\r\nFechaInicio [new]: 2018-02-01 00:00:00\r\nFechaFin [new]: 2018-02-05 00:00:00\r\n'),
 (30,'2018-02-24 18:23:50','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (31,'2018-02-24 18:34:28','::1','humanes','user_peticion','add','---Keys\r\nidpeticion : 6\r\n---Fields\r\nusuario_idusuario [new]: 2\r\nperiodo_idperiodo [new]: 1\r\nFechaInicio [new]: 2018-02-05 00:00:00\r\nFechaFin [new]: 2018-02-28 00:00:00\r\n'),
 (32,'2018-02-24 18:35:00','::1','humanes','user_peticion','add','---Keys\r\nidpeticion : 7\r\n---Fields\r\nusuario_idusuario [new]: 2\r\nperiodo_idperiodo [new]: 1\r\nFechaInicio [new]: 2018-01-01 00:00:00\r\nFechaFin [new]: 2018-01-10 00:00:00\r\n'),
 (33,'2018-02-24 18:36:37','::1','humanes','user_usuario','edit','---Keys\r\nidusuario : 2\r\n'),
 (34,'2018-02-24 18:37:00','::1','humanes','user_usuario','edit','---Keys\r\nidusuario : 2\r\n'),
 (35,'2018-02-24 18:47:21','::1','humanes','user_peticion','edit','---Keys\r\nidpeticion : 7\r\n'),
 (36,'2018-02-24 19:06:32','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (37,'2018-02-24 19:18:06','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (38,'2018-02-24 19:20:04','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (39,'2018-02-24 19:20:15','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (40,'2018-02-24 19:21:32','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (41,'2018-02-24 19:22:13','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (42,'2018-02-24 19:22:22','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (43,'2018-02-24 19:23:13','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (44,'2018-02-24 19:30:02','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (45,'2018-02-24 19:45:58','::1','admin','usuario_grupo','add','---Keys\r\nidusuario_grupo : 4\r\n---Fields\r\nusuario_idusuario [new]: 1\r\ngrupo_trabajo_idgrupo_trabajo [new]: 2\r\n'),
 (46,'2018-02-24 21:25:35','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (47,'2018-02-25 10:49:40','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (48,'2018-02-25 11:37:45','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (49,'2018-02-25 11:40:53','::1','admin','periodo','edit','---Keys\r\nidperiodo : 1\r\n---Fields\r\nFechaInicio [old]: 2017-12-01 00:00:00\r\nFechaInicio [new]: 2017-12-11 00:00:00\r\nFechaFin [old]: 2018-01-21 00:00:00\r\nFechaFin [new]: 2018-01-30 00:00:00\r\n'),
 (50,'2018-02-25 13:04:02','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (51,'2018-02-26 13:04:35','::1','admin','periodo','edit','---Keys\r\nidperiodo : 1\r\n---Fields\r\nFechaInicio [old]: 2017-12-11 00:00:00\r\nFechaInicio [new]: 2017-12-10 00:00:00\r\nFechaFin [old]: 2018-01-30 00:00:00\r\nFechaFin [new]: 2018-02-15 00:00:00\r\n'),
 (52,'2018-02-26 13:05:45','::1','admin','peticion','edit','---Keys\r\nidpeticion : 6\r\n---Fields\r\nFechaFin [old]: 2018-02-28 00:00:00\r\nFechaFin [new]: 2018-02-08 00:00:00\r\n'),
 (53,'2018-02-26 13:13:16','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (54,'2018-02-26 13:54:09','::1','admin','festivos','add','---Keys\r\nidfestivos : 3\r\n---Fields\r\nDiaFiesta [new]: 2018-02-05 00:00:00\r\nTitulo [new]: sábado\r\n'),
 (55,'2018-02-26 13:54:16','::1','admin','festivos','delete','---Keys\r\nidfestivos : 3\r\n---Fields\r\nDiaFiesta [old]: 2018-02-05\r\nTitulo [old]: sábado\r\n'),
 (56,'2018-02-26 13:55:56','::1','admin','festivos','edit','---Keys\r\nidfestivos : 2\r\n---Fields\r\nDiaFiesta [old]: 2018-01-06 00:00:00\r\nDiaFiesta [new]: 2018-01-08 00:00:00\r\n'),
 (57,'2018-02-26 14:35:03','::1','admin','periodo','edit','---Keys\r\nidperiodo : 1\r\n---Fields\r\nAbierto [old]: 0\r\nAbierto [new]: 1\r\n'),
 (58,'2018-02-26 14:37:34','::1','admin','periodo','add','---Keys\r\nidperiodo : 3\r\n---Fields\r\nTitulo [new]: frfr\r\nDescripcion [new]: frfrfr\r\nFechaInicio [new]: 2018-04-16 00:00:00\r\nFechaFin [new]: 2018-04-25 00:00:00\r\n'),
 (59,'2018-02-26 14:37:44','::1','admin','periodo','delete','---Keys\r\nidperiodo : 3\r\n---Fields\r\nTitulo [old]: frfr\r\nDescripcion [old]: frfrfr\r\nFechaInicio [old]: 2018-04-16\r\nFechaFin [old]: 2018-04-25\r\nAbierto [old]: 0\r\n'),
 (60,'2018-02-26 14:38:05','::1','admin','periodo','add','---Keys\r\nidperiodo : 4\r\n---Fields\r\nTitulo [new]: frrrr\r\nDescripcion [new]: rrrr\r\nFechaInicio [new]: 2018-05-16 00:00:00\r\nFechaFin [new]: 2018-05-31 00:00:00\r\nAbierto [new]: 1\r\n'),
 (61,'2018-02-26 14:38:30','::1','admin','periodo','delete','---Keys\r\nidperiodo : 4\r\n---Fields\r\nTitulo [old]: frrrr\r\nDescripcion [old]: rrrr\r\nFechaInicio [old]: 2018-05-16\r\nFechaFin [old]: 2018-05-31\r\nAbierto [old]: 1\r\n'),
 (62,'2018-02-26 14:38:39','::1','admin','periodo','edit','---Keys\r\nidperiodo : 1\r\n---Fields\r\nAbierto [old]: 0\r\nAbierto [new]: 1\r\n'),
 (63,'2018-02-26 16:25:06','::1','admin','peticion','edit','---Keys\r\nidpeticion : 6\r\n'),
 (64,'2018-02-26 16:25:29','::1','admin','peticion','edit','---Keys\r\nidpeticion : 6\r\n---Fields\r\nFechaInicio [old]: 2018-02-05 00:00:00\r\nFechaInicio [new]: 2018-02-01 00:00:00\r\n'),
 (65,'2018-02-26 16:49:29','::1','admin','peticion','edit','---Keys\r\nidpeticion : 6\r\n---Fields\r\nDiasNaturales [old]: \r\nDiasNaturales [new]: 120\r\nDiasLaborables [old]: 0\r\nDiasLaborables [new]: 85\r\nDiasFiesta [old]: \r\nDiasFiesta [new]: 2\r\nDiasFinSemana [old]: \r\nDiasFinSemana [new]: 33\r\n'),
 (66,'2018-02-26 16:49:38','::1','admin','peticion','edit','---Keys\r\nidpeticion : 5\r\n---Fields\r\nDiasNaturales [old]: \r\nDiasNaturales [new]: 120\r\nDiasLaborables [old]: 0\r\nDiasLaborables [new]: 85\r\nDiasFiesta [old]: \r\nDiasFiesta [new]: 2\r\nDiasFinSemana [old]: \r\nDiasFinSemana [new]: 33\r\n'),
 (67,'2018-02-26 16:49:47','::1','admin','peticion','edit','---Keys\r\nidpeticion : 4\r\n---Fields\r\nDiasNaturales [old]: \r\nDiasNaturales [new]: 120\r\nDiasLaborables [old]: 0\r\nDiasLaborables [new]: 85\r\nDiasFiesta [old]: \r\nDiasFiesta [new]: 2\r\nDiasFinSemana [old]: \r\nDiasFinSemana [new]: 33\r\n'),
 (68,'2018-02-26 16:51:38','::1','admin','peticion','edit','---Keys\r\nidpeticion : 6\r\n---Fields\r\nDiasNaturales [old]: 120\r\nDiasNaturales [new]: 7\r\nDiasLaborables [old]: 85\r\nDiasLaborables [new]: 6\r\nDiasFiesta [old]: 2\r\nDiasFiesta [new]: 0\r\nDiasFinSemana [old]: 33\r\nDiasFinSemana [new]: 1\r\n'),
 (69,'2018-02-26 16:51:46','::1','admin','peticion','edit','---Keys\r\nidpeticion : 5\r\n---Fields\r\nDiasNaturales [old]: 120\r\nDiasNaturales [new]: 4\r\nDiasLaborables [old]: 85\r\nDiasLaborables [new]: 3\r\nDiasFiesta [old]: 2\r\nDiasFiesta [new]: 0\r\nDiasFinSemana [old]: 33\r\nDiasFinSemana [new]: 1\r\n'),
 (70,'2018-02-26 16:51:52','::1','admin','peticion','edit','---Keys\r\nidpeticion : 4\r\n---Fields\r\nDiasNaturales [old]: 120\r\nDiasNaturales [new]: 7\r\nDiasLaborables [old]: 85\r\nDiasLaborables [new]: 5\r\nDiasFiesta [old]: 2\r\nDiasFiesta [new]: 1\r\nDiasFinSemana [old]: 33\r\nDiasFinSemana [new]: 1\r\n'),
 (71,'2018-02-26 16:51:58','::1','admin','peticion','edit','---Keys\r\nidpeticion : 7\r\n---Fields\r\nDiasNaturales [old]: \r\nDiasNaturales [new]: 9\r\nDiasLaborables [old]: 0\r\nDiasLaborables [new]: 6\r\nDiasFiesta [old]: \r\nDiasFiesta [new]: 2\r\nDiasFinSemana [old]: \r\nDiasFinSemana [new]: 1\r\n'),
 (72,'2018-02-26 16:52:07','::1','admin','peticion','edit','---Keys\r\nidpeticion : 1\r\n---Fields\r\nDiasNaturales [old]: 0\r\nDiasNaturales [new]: 11\r\nDiasLaborables [old]: 0\r\nDiasLaborables [new]: 9\r\nDiasFinSemana [old]: 0\r\nDiasFinSemana [new]: 2\r\n'),
 (73,'2018-02-26 17:08:12','::1','admin','peticion','edit','---Keys\r\nidpeticion : 5\r\n'),
 (74,'2018-02-26 17:08:16','::1','admin','peticion','edit','---Keys\r\nidpeticion : 6\r\n'),
 (75,'2018-02-26 17:08:23','::1','admin','peticion','edit','---Keys\r\nidpeticion : 4\r\n'),
 (76,'2018-02-26 17:08:34','::1','admin','peticion','edit','---Keys\r\nidpeticion : 1\r\n'),
 (77,'2018-02-26 20:30:21','::1','admin','peticion','edit','---Keys\r\nidpeticion : 5\r\n'),
 (78,'2018-02-26 20:32:17','::1','admin','peticion','edit','---Keys\r\nidpeticion : 5\r\n'),
 (79,'2018-02-26 20:32:21','::1','admin','peticion','edit','---Keys\r\nidpeticion : 6\r\n'),
 (80,'2018-02-26 20:32:24','::1','admin','peticion','edit','---Keys\r\nidpeticion : 7\r\n'),
 (81,'2018-02-26 20:32:28','::1','admin','peticion','edit','---Keys\r\nidpeticion : 1\r\n'),
 (82,'2018-02-26 20:34:38','::1','admin','user_peticion','edit','---Keys\r\nidpeticion : 5\r\n'),
 (83,'2018-02-26 20:37:31','::1','admin','user_peticion','edit','---Keys\r\nidpeticion : 5\r\n---Fields\r\nFechaFin [old]: 2018-02-05 00:00:00\r\nFechaFin [new]: 2018-02-04 00:00:00\r\nDiasNaturales [old]: 4\r\nDiasNaturales [new]: 3\r\nDiasLaborables [old]: 3\r\nDiasLaborables [new]: 2\r\n'),
 (84,'2018-02-26 20:37:41','::1','admin','user_peticion','edit','---Keys\r\nidpeticion : 5\r\n---Fields\r\nFechaFin [old]: 2018-02-04 00:00:00\r\nFechaFin [new]: 2018-02-06 00:00:00\r\nDiasNaturales [old]: 3\r\nDiasNaturales [new]: 5\r\nDiasLaborables [old]: 2\r\nDiasLaborables [new]: 4\r\n'),
 (85,'2018-02-26 20:38:09','::1','admin','user_peticion','edit','---Keys\r\nidpeticion : 5\r\n'),
 (86,'2018-02-26 20:38:15','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (87,'2018-04-04 19:42:16','::1','admin','user_peticion','add','---Keys\r\nidpeticion : 8\r\n---Fields\r\nusuario_idusuario [new]: 1\r\nperiodo_idperiodo [new]: 1\r\nFechaInicio [new]: 2017-12-11 00:00:00\r\nFechaFin [new]: 2017-12-12 00:00:00\r\nDiasNaturales [new]: 1\r\nDiasLaborables [new]: 2\r\nDiasFinSemana [new]: -1\r\nDiasFiesta [new]: 0\r\n'),
 (88,'2018-04-04 19:59:08','::1','admin','user_peticion','edit','---Keys\r\nidpeticion : 8\r\n---Fields\r\nDiasNaturales [old]: 1\r\nDiasNaturales [new]: 2\r\nDiasFinSemana [old]: -1\r\nDiasFinSemana [new]: 0\r\n'),
 (89,'2018-04-04 19:59:20','::1','admin','user_peticion','edit','---Keys\r\nidpeticion : 5\r\n---Fields\r\nDiasNaturales [old]: 5\r\nDiasNaturales [new]: 6\r\nDiasFinSemana [old]: 1\r\nDiasFinSemana [new]: 2\r\n'),
 (90,'2018-04-04 20:00:22','::1','admin','user_peticion','edit','---Keys\r\nidpeticion : 1\r\n---Fields\r\nDiasNaturales [old]: 11\r\nDiasNaturales [new]: 12\r\nDiasFinSemana [old]: 2\r\nDiasFinSemana [new]: 3\r\n'),
 (91,'2018-04-04 20:00:25','::1','admin','user_peticion','edit','---Keys\r\nidpeticion : 4\r\n---Fields\r\nDiasNaturales [old]: 7\r\nDiasNaturales [new]: 8\r\nDiasFinSemana [old]: 1\r\nDiasFinSemana [new]: 2\r\n'),
 (92,'2018-04-04 20:00:57','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (93,'2018-04-04 20:04:02','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (94,'2018-04-04 20:08:22','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (95,'2018-04-28 19:42:53','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (96,'2018-05-04 14:33:34','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (97,'2018-05-04 14:37:05','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (98,'2018-05-04 14:39:37','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (99,'2018-06-27 18:28:59','::1','admin','periodo','edit','---Keys\r\nidperiodo : 1\r\n---Fields\r\nFechaInicio [old]: 2017-12-10 00:00:00\r\nFechaInicio [new]: 2017-12-11 00:00:00\r\n'),
 (100,'2018-06-27 18:37:45','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (101,'2018-06-27 18:38:35','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (102,'2018-06-27 18:47:21','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (103,'2018-06-27 18:55:42','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (104,'2018-06-27 19:08:26','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (105,'2018-06-27 19:10:04','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (106,'2018-07-15 18:50:21','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (107,'2018-07-15 18:52:10','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (108,'2019-06-11 17:57:45','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (109,'2019-06-11 17:57:52','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (110,'2019-10-09 13:06:30','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (111,'2019-12-09 18:51:01','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (112,'2019-12-09 19:01:08','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (113,'2019-12-09 20:10:47','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (114,'2019-12-09 20:15:41','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (115,'2019-12-09 20:18:40','::1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (116,'2019-12-20 20:16:34','::1','admin','usuario','edit','---Keys\r\nidusuario : 1\r\n---Fields\r\nPassword [old]: 1e63dafa7e63f073ed2f362a49f8cf24\r\nPassword [new]: 21232f297a57a5a743894a0e4a801fc3\r\nFechaUltModificacion [old]: 2018-02-24 00:00:00\r\nFechaUltModificacion [new]: 2019-12-20 20:16:34\r\n'),
 (117,'2022-07-20 17:57:07','127.0.0.1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (118,'2023-04-20 18:40:00','127.0.0.1','admin','periodo','add','---Keys\r\nidperiodo : 3\r\n---Fields\r\nTitulo [new]: año 2023\r\nDescripcion [new]: Todo el año 2023\r\nFechaInicio [new]: 2023-01-01 00:00:00\r\nFechaFin [new]: 2023-12-31 00:00:00\r\nAbierto [new]: 1\r\n'),
 (119,'2023-04-20 18:41:09','127.0.0.1','admin','user_peticion','add','---Keys\r\nidpeticion : 9\r\n---Fields\r\nusuario_idusuario [new]: 1\r\nperiodo_idperiodo [new]: 3\r\nFechaInicio [new]: 2023-04-21 00:00:00\r\nFechaFin [new]: 2023-04-30 00:00:00\r\nDiasNaturales [new]: 10\r\nDiasLaborables [new]: 6\r\nDiasFinSemana [new]: 4\r\nDiasFiesta [new]: 0\r\n'),
 (120,'2023-04-20 18:41:14','127.0.0.1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (121,'2023-04-20 20:10:42','127.0.0.1','admin','peticion','edit','---Keys\r\nidpeticion : 9\r\n---Fields\r\nFechaFin [old]: 2023-04-30 00:00:00\r\nFechaFin [new]: 2023-05-03 00:00:00\r\nDiasNaturales [old]: 10\r\nDiasNaturales [new]: 12\r\nDiasLaborables [old]: 6\r\nDiasLaborables [new]: 9\r\nDiasFinSemana [old]: 4\r\nDiasFinSemana [new]: 3\r\n'),
 (122,'2023-04-20 20:11:16','127.0.0.1','admin','user_peticion','edit','---Keys\r\nidpeticion : 9\r\n---Fields\r\nDiasNaturales [old]: 12\r\nDiasNaturales [new]: 13\r\nDiasFinSemana [old]: 3\r\nDiasFinSemana [new]: 4\r\n'),
 (123,'2023-04-20 20:47:46','127.0.0.1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (124,'2023-04-20 20:54:07','127.0.0.1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (125,'2023-04-21 14:16:07','127.0.0.1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (126,'2023-04-21 17:57:44','127.0.0.1','humanes','user_peticion','add','---Keys\r\nidpeticion : 10\r\n---Fields\r\nusuario_idusuario [new]: 2\r\nperiodo_idperiodo [new]: 3\r\nFechaInicio [new]: 2023-04-19 00:00:00\r\nFechaFin [new]: 2023-05-09 00:00:00\r\nDiasNaturales [new]: 21\r\nDiasLaborables [new]: 15\r\nDiasFinSemana [new]: 6\r\nDiasFiesta [new]: 0\r\n'),
 (127,'2023-04-21 17:57:47','127.0.0.1','humanes','user_usuario','edit','---Keys\r\nidusuario : 2\r\n'),
 (128,'2023-04-21 17:58:24','127.0.0.1','humanes','user_usuario','edit','---Keys\r\nidusuario : 2\r\n'),
 (129,'2023-04-21 18:29:51','127.0.0.1','admin','grupo_trabajo','edit','---Keys\r\nidgrupo_trabajo : 1\r\n---Fields\r\nColor [old]: #000000\r\nColor [new]: #67E06D\r\n'),
 (130,'2023-04-21 18:30:01','127.0.0.1','admin','grupo_trabajo','edit','---Keys\r\nidgrupo_trabajo : 2\r\n---Fields\r\nColor [old]: #51EB46\r\nColor [new]: #88C5E3\r\n'),
 (131,'2023-04-21 18:30:44','127.0.0.1','admin','usuario','edit','---Keys\r\nidusuario : 2\r\n---Fields\r\nColor [old]: #71DE0B\r\nColor [new]: #70DBD4\r\nFechaUltModificacion [old]: 2018-02-21 00:00:00\r\nFechaUltModificacion [new]: 2023-04-21 18:30:44\r\n'),
 (132,'2023-04-21 18:30:56','127.0.0.1','admin','usuario','edit','---Keys\r\nidusuario : 1\r\n---Fields\r\nColor [old]: #C91C5C\r\nColor [new]: #DE57F0\r\nFechaUltModificacion [old]: 2019-12-20 00:00:00\r\nFechaUltModificacion [new]: 2023-04-21 18:30:56\r\n'),
 (133,'2023-04-21 18:53:16','127.0.0.1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (134,'2023-04-21 19:33:39','127.0.0.1','admin','usuario','edit','---Keys\r\nidusuario : 2\r\n---Fields\r\nFechaUltModificacion [old]: 2023-04-21 00:00:00\r\nFechaUltModificacion [new]: 2023-04-21 19:33:39\r\nJefe_id [old]: \r\nJefe_id [new]: 1\r\n'),
 (135,'2023-04-21 19:33:58','127.0.0.1','admin','usuario','edit','---Keys\r\nidusuario : 1\r\n---Fields\r\nFechaUltModificacion [old]: 2023-04-21 00:00:00\r\nFechaUltModificacion [new]: 2023-04-21 19:33:58\r\nJefe_id [old]: \r\nJefe_id [new]: 1\r\n'),
 (136,'2023-04-21 19:49:38','127.0.0.1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (137,'2023-04-21 20:25:45','127.0.0.1','admin','user_peticion','edit','---Keys\r\nidpeticion : 9\r\n'),
 (138,'2023-04-21 20:29:13','127.0.0.1','admin','peticion','edit','---Keys\r\nidpeticion : 9\r\n---Fields\r\nStatus [old]: 0\r\nStatus [new]: 1\r\nDiasNaturales [old]: 13\r\nDiasNaturales [new]: 12\r\nDiasFinSemana [old]: 4\r\nDiasFinSemana [new]: 3\r\n'),
 (139,'2023-04-21 20:45:35','127.0.0.1','humanes','user_usuario','edit','---Keys\r\nidusuario : 2\r\n'),
 (140,'2023-04-21 20:52:28','127.0.0.1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (141,'2023-04-22 20:41:11','127.0.0.1','admin','peticion','edit','---Keys\r\nidpeticion : 9\r\n'),
 (142,'2023-04-22 21:39:33','127.0.0.1','admin','user_aprobacion','edit','---Keys\r\nidpeticion : 9\r\n---Fields\r\nStatus [old]: 1\r\nStatus [new]: 0\r\n'),
 (143,'2023-04-22 21:42:18','127.0.0.1','admin','user_aprobacion','edit','---Keys\r\nidpeticion : 9\r\n---Fields\r\nStatus [old]: 0\r\nStatus [new]: 1\r\n'),
 (144,'2023-04-23 19:17:00','127.0.0.1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (145,'2023-04-23 19:29:06','127.0.0.1','admin','user_aprobacion','edit','---Keys\r\nidpeticion : 10\r\n---Fields\r\nStatus [old]: 0\r\nStatus [new]: 1\r\n'),
 (146,'2023-04-23 19:29:15','127.0.0.1','admin','user_aprobacion','edit','---Keys\r\nidpeticion : 10\r\n---Fields\r\nStatus [old]: 1\r\nStatus [new]: 0\r\n'),
 (147,'2023-04-23 19:29:41','127.0.0.1','admin','user_aprobacion','edit','---Keys\r\nidpeticion : 9\r\n---Fields\r\nStatus [old]: 1\r\nStatus [new]: 0\r\n'),
 (148,'2023-04-23 19:29:52','127.0.0.1','admin','user_aprobacion','edit','---Keys\r\nidpeticion : 9\r\n---Fields\r\nStatus [old]: 0\r\nStatus [new]: 1\r\n'),
 (149,'2023-04-23 19:46:03','127.0.0.1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (150,'2023-04-30 13:47:32','127.0.0.1','admin','festivos','add','---Keys\r\nidfestivos : 3\r\n---Fields\r\nDiaFiesta [new]: 2023-05-02 00:00:00\r\n'),
 (151,'2023-04-30 13:47:32','127.0.0.1','admin','festivos','add','---Keys\r\nidfestivos : 4\r\n---Fields\r\nDiaFiesta [new]: 2023-04-17 00:00:00\r\n'),
 (152,'2023-04-30 13:47:32','127.0.0.1','admin','festivos','add','---Keys\r\nidfestivos : 5\r\n---Fields\r\nDiaFiesta [new]: 2023-04-14 00:00:00\r\n'),
 (153,'2023-04-30 13:53:33','127.0.0.1','admin','festivos','add','---Keys\r\nidfestivos : 6\r\n---Fields\r\nDiaFiesta [new]: 2023-05-16 00:00:00\r\n'),
 (154,'2023-04-30 14:03:06','127.0.0.1','admin','user_usuario','edit','---Keys\r\nidusuario : 1\r\n'),
 (155,'2023-05-01 13:40:50','127.0.0.1','admin','festivos','delete','---Keys\r\nidfestivos : 3\r\n---Fields\r\nDiaFiesta [old]: 2023-05-02\r\n'),
 (156,'2023-05-01 13:40:50','127.0.0.1','admin','festivos','delete','---Keys\r\nidfestivos : 4\r\n---Fields\r\nDiaFiesta [old]: 2023-04-17\r\n'),
 (157,'2023-05-01 13:40:50','127.0.0.1','admin','festivos','delete','---Keys\r\nidfestivos : 5\r\n---Fields\r\nDiaFiesta [old]: 2023-04-14\r\n'),
 (158,'2023-05-01 13:40:50','127.0.0.1','admin','festivos','delete','---Keys\r\nidfestivos : 6\r\n---Fields\r\nDiaFiesta [old]: 2023-05-16\r\n'),
 (159,'2023-05-01 13:42:54','127.0.0.1','admin','festivos','add','---Keys\r\nidfestivos : 7\r\n---Fields\r\nDiaFiesta [new]: 2023-01-06 00:00:00\r\n'),
 (160,'2023-05-01 13:42:54','127.0.0.1','admin','festivos','add','---Keys\r\nidfestivos : 8\r\n---Fields\r\nDiaFiesta [new]: 2023-03-20 00:00:00\r\n'),
 (161,'2023-05-01 13:42:54','127.0.0.1','admin','festivos','add','---Keys\r\nidfestivos : 9\r\n---Fields\r\nDiaFiesta [new]: 2023-04-06 00:00:00\r\n'),
 (162,'2023-05-01 13:42:54','127.0.0.1','admin','festivos','add','---Keys\r\nidfestivos : 10\r\n---Fields\r\nDiaFiesta [new]: 2023-05-01 00:00:00\r\n'),
 (163,'2023-05-01 13:42:54','127.0.0.1','admin','festivos','add','---Keys\r\nidfestivos : 11\r\n---Fields\r\nDiaFiesta [new]: 2023-04-07 00:00:00\r\n'),
 (164,'2023-05-01 13:42:54','127.0.0.1','admin','festivos','add','---Keys\r\nidfestivos : 12\r\n---Fields\r\nDiaFiesta [new]: 2023-05-02 00:00:00\r\n'),
 (165,'2023-05-01 13:42:55','127.0.0.1','admin','festivos','add','---Keys\r\nidfestivos : 13\r\n---Fields\r\nDiaFiesta [new]: 2023-08-15 00:00:00\r\n'),
 (166,'2023-05-01 13:42:55','127.0.0.1','admin','festivos','add','---Keys\r\nidfestivos : 14\r\n---Fields\r\nDiaFiesta [new]: 2023-10-12 00:00:00\r\n'),
 (167,'2023-05-01 13:42:55','127.0.0.1','admin','festivos','add','---Keys\r\nidfestivos : 15\r\n---Fields\r\nDiaFiesta [new]: 2023-11-01 00:00:00\r\n'),
 (168,'2023-05-01 13:42:55','127.0.0.1','admin','festivos','add','---Keys\r\nidfestivos : 16\r\n---Fields\r\nDiaFiesta [new]: 2023-12-06 00:00:00\r\n'),
 (169,'2023-05-01 13:42:55','127.0.0.1','admin','festivos','add','---Keys\r\nidfestivos : 17\r\n---Fields\r\nDiaFiesta [new]: 2023-12-08 00:00:00\r\n'),
 (170,'2023-05-01 13:42:55','127.0.0.1','admin','festivos','add','---Keys\r\nidfestivos : 18\r\n---Fields\r\nDiaFiesta [new]: 2023-12-25 00:00:00\r\n'),
 (171,'2023-05-01 13:46:00','127.0.0.1','admin','festivos','add','---Keys\r\nidfestivos : 19\r\n---Fields\r\nDiaFiesta [new]: 2022-04-14 00:00:00\r\n'),
 (172,'2023-05-01 13:46:00','127.0.0.1','admin','festivos','add','---Keys\r\nidfestivos : 20\r\n---Fields\r\nDiaFiesta [new]: 2022-01-06 00:00:00\r\n'),
 (173,'2023-05-01 13:46:00','127.0.0.1','admin','festivos','add','---Keys\r\nidfestivos : 21\r\n---Fields\r\nDiaFiesta [new]: 2022-04-15 00:00:00\r\n'),
 (174,'2023-05-01 13:46:00','127.0.0.1','admin','festivos','add','---Keys\r\nidfestivos : 22\r\n---Fields\r\nDiaFiesta [new]: 2022-05-02 00:00:00\r\n'),
 (175,'2023-05-01 13:46:00','127.0.0.1','admin','festivos','add','---Keys\r\nidfestivos : 23\r\n---Fields\r\nDiaFiesta [new]: 2022-07-25 00:00:00\r\n'),
 (176,'2023-05-01 13:46:00','127.0.0.1','admin','festivos','add','---Keys\r\nidfestivos : 24\r\n---Fields\r\nDiaFiesta [new]: 2022-08-15 00:00:00\r\n'),
 (177,'2023-05-01 13:46:00','127.0.0.1','admin','festivos','add','---Keys\r\nidfestivos : 25\r\n---Fields\r\nDiaFiesta [new]: 2022-10-12 00:00:00\r\n'),
 (178,'2023-05-01 13:46:00','127.0.0.1','admin','festivos','add','---Keys\r\nidfestivos : 26\r\n---Fields\r\nDiaFiesta [new]: 2022-11-01 00:00:00\r\n'),
 (179,'2023-05-01 13:46:00','127.0.0.1','admin','festivos','add','---Keys\r\nidfestivos : 27\r\n---Fields\r\nDiaFiesta [new]: 2022-12-06 00:00:00\r\n'),
 (180,'2023-05-01 13:46:00','127.0.0.1','admin','festivos','add','---Keys\r\nidfestivos : 28\r\n---Fields\r\nDiaFiesta [new]: 2022-12-08 00:00:00\r\n'),
 (181,'2023-05-01 13:46:00','127.0.0.1','admin','festivos','add','---Keys\r\nidfestivos : 29\r\n---Fields\r\nDiaFiesta [new]: 2022-12-26 00:00:00\r\n'),
 (182,'2023-05-04 20:22:20','127.0.0.1','admin','user_aprobacion','edit','---Keys\r\nidpeticion : 10\r\n');
/*!40000 ALTER TABLE `vacaciones_audit` ENABLE KEYS */;


--
-- Definition of table `vacaciones_settings`
--

DROP TABLE IF EXISTS `vacaciones_settings`;
CREATE TABLE `vacaciones_settings` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `TYPE` int(11) DEFAULT '1',
  `NAME` mediumtext,
  `USERNAME` mediumtext,
  `COOKIE` varchar(500) DEFAULT NULL,
  `SEARCH` mediumtext,
  `TABLENAME` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `vacaciones_settings`
--

/*!40000 ALTER TABLE `vacaciones_settings` DISABLE KEYS */;
INSERT INTO `vacaciones_settings` (`ID`,`TYPE`,`NAME`,`USERNAME`,`COOKIE`,`SEARCH`,`TABLENAME`) VALUES 
 (1,2,NULL,'admin',NULL,'{\"gridWidth\":591.2,\"thWidths\":{\"idfestivos\":67.2,\"DiaFiesta\":109.2,\"Titulo\":303.2}}','festivos'),
 (2,2,NULL,'admin',NULL,'{\"gridWidth\":1033.2,\"thWidths\":{\"idusuario\":81.2,\"Login\":96.2,\"NombreyApellido\":216.2,\"Password\":66.2,\"Color\":91.2,\"UsuarioUltModificacion\":85.2,\"FechaUltModificacion\":156.2}}','usuario'),
 (3,2,NULL,'admin',NULL,'{\"gridWidth\":1015.4,\"thWidths\":{\"grid_headcell_icons\":13.399999999999999,\"grid_headcell_checkbox\":12.399999999999999,\"grid_headcell_details\":47.4,\"grid_headcell_field\":87.4,\"grid_headcell_field1\":97.4,\"grid_headcell_field2\":379.4,\"grid_headcell_field3\":255.4}}','grupo_trabajo'),
 (4,2,NULL,'admin',NULL,'{\"gridWidth\":607.2,\"thWidths\":{\"idusuario_grupo\":109.2,\"usuario_idusuario\":179.2,\"grupo_trabajo_idgrupo_trabajo\":207.2}}','usuario_grupo'),
 (5,2,NULL,'admin',NULL,'{\"gridWidth\":1015.2,\"thWidths\":{\"idusuario\":63.2,\"Login\":86.2,\"NombreyApellido\":356.2,\"Password\":66.2,\"Color\":84.2,\"UsuarioUltModificacion\":89.2,\"FechaUltModificacion\":152.2}}','admin_users'),
 (6,2,NULL,'admin',NULL,'{\"gridWidth\":929.2,\"thWidths\":{\"idperiodo\":72.2,\"Titulo\":123.2,\"Descripcion\":293.2,\"FechaInicio\":112.2,\"FechaFin\":83.2,\"Abierto\":61.2}}','periodo'),
 (7,2,NULL,'admin',NULL,'{\"gridWidth\":1019.2,\"thWidths\":{\"idpeticion\":67.2,\"usuario_idusuario\":119.2,\"periodo_idperiodo\":163.2,\"FechaInicio\":102.2,\"FechaFin\":70.2,\"DiasNaturales\":97.2,\"DiasFinSemana\":112.2,\"DiasFiesta\":74.2}}','peticion'),
 (8,2,NULL,'admin',NULL,'{\"gridWidth\":876.2,\"thWidths\":{\"idgrupo_trabajo\":86.2,\"Titulo\":128.2,\"Descripcion\":576.2}}','user_grupo'),
 (9,2,NULL,'admin',NULL,'{\"gridWidth\":802,\"thWidths\":{\"idpeticion\":67,\"periodo_idperiodo\":189,\"FechaInicio\":81,\"FechaFin\":70,\"DiasNaturales\":97,\"DiasFinSemana\":112,\"DiasFiesta\":74}}','user_peticion'),
 (10,2,NULL,'humanes',NULL,'{\"gridWidth\":908,\"thWidths\":{\"idpeticion\":67,\"periodo_idperiodo\":214,\"FechaInicio\":102,\"FechaFin\":70,\"DiasNaturales\":97,\"DiasFinSemana\":112,\"DiasFiesta\":74}}','user_peticion'),
 (11,2,NULL,'humanes',NULL,'{\"gridWidth\":1148.2,\"thWidths\":{\"idgrupo_trabajo\":75.2,\"Titulo\":54.2,\"Descripcion\":935.2}}','user_grupo'),
 (12,2,NULL,'admin',NULL,'{\"gridWidth\":743.4,\"thWidths\":{\"grid_headcell_icons\":31.4,\"grid_headcell_field\":66.4,\"grid_headcell_field1\":251.4,\"grid_headcell_field2\":80.4,\"grid_headcell_field3\":113.4,\"grid_headcell_field4\":95.4}}','user_aprobacion');
/*!40000 ALTER TABLE `vacaciones_settings` ENABLE KEYS */;


--
-- Definition of table `vacaciones_uggroups`
--

DROP TABLE IF EXISTS `vacaciones_uggroups`;
CREATE TABLE `vacaciones_uggroups` (
  `GroupID` int(11) NOT NULL AUTO_INCREMENT,
  `Label` varchar(300) DEFAULT NULL,
  `Provider` varchar(10) NOT NULL DEFAULT '',
  `Comment` mediumtext,
  PRIMARY KEY (`GroupID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `vacaciones_uggroups`
--

/*!40000 ALTER TABLE `vacaciones_uggroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `vacaciones_uggroups` ENABLE KEYS */;


--
-- Definition of table `vacaciones_ugmembers`
--

DROP TABLE IF EXISTS `vacaciones_ugmembers`;
CREATE TABLE `vacaciones_ugmembers` (
  `UserName` varchar(255) NOT NULL,
  `GroupID` int(11) NOT NULL,
  `Provider` varchar(10) NOT NULL DEFAULT '',
  PRIMARY KEY (`UserName`,`GroupID`,`Provider`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `vacaciones_ugmembers`
--

/*!40000 ALTER TABLE `vacaciones_ugmembers` DISABLE KEYS */;
INSERT INTO `vacaciones_ugmembers` (`UserName`,`GroupID`,`Provider`) VALUES 
 ('admin',-1,'');
/*!40000 ALTER TABLE `vacaciones_ugmembers` ENABLE KEYS */;


--
-- Definition of table `vacaciones_ugrights`
--

DROP TABLE IF EXISTS `vacaciones_ugrights`;
CREATE TABLE `vacaciones_ugrights` (
  `TableName` varchar(300) NOT NULL,
  `GroupID` int(11) NOT NULL,
  `AccessMask` varchar(10) DEFAULT NULL,
  `Page` mediumtext,
  PRIMARY KEY (`TableName`(50),`GroupID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `vacaciones_ugrights`
--

/*!40000 ALTER TABLE `vacaciones_ugrights` DISABLE KEYS */;
INSERT INTO `vacaciones_ugrights` (`TableName`,`GroupID`,`AccessMask`,`Page`) VALUES 
 ('admin_members',-1,'ADESPIM',NULL),
 ('admin_rights',-1,'ADESPIM',NULL),
 ('admin_users',-1,'ADESPIM',NULL),
 ('festivos',-1,'ADESPIM',NULL),
 ('grupo_trabajo',-1,'ADESPIM',NULL),
 ('grupo_trabajo_search',-2,'S',''),
 ('periodo',-1,'ADESPIM',NULL),
 ('periodo_search',-2,'S',''),
 ('peticion',-2,'S',''),
 ('peticion',-1,'ADESPIM',NULL),
 ('user_aprobacion',-2,'ES',''),
 ('user_aprobacion',-1,'ES',''),
 ('user_grupo',-2,'S',''),
 ('user_grupo',-1,'S',NULL),
 ('user_peticion',-2,'AEDS',''),
 ('user_peticion',-1,'AEDS',NULL),
 ('user_usuario',-2,'ES',''),
 ('user_usuario',-1,'AEDSPI',NULL),
 ('usuario',-1,'ADESPIM',NULL),
 ('usuario_grupo',-1,'ADESPIM',NULL);
/*!40000 ALTER TABLE `vacaciones_ugrights` ENABLE KEYS */;


--
-- Definition of function `workdaydiff`
--

DROP FUNCTION IF EXISTS `workdaydiff`;

DELIMITER $$

/*!50003 SET @TEMP_SQL_MODE=@@SQL_MODE, SQL_MODE='STRICT_TRANS_TABLES,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ $$
CREATE  FUNCTION `workdaydiff`(b date, a date) RETURNS int(11)
    DETERMINISTIC
    COMMENT 'working day difference for 2 dates'
BEGIN

DECLARE freedays int;
 
SET freedays = 0;
SET @x = DATEDIFF(b, a);
IF @x<0 THEN
SET @m = a;
SET a = b;
SET b = @m;
SET @m = -1;
ELSE
SET @m = 1;
END IF;
SET @x = abs(@x) + 1;
 
SET @w1 = WEEKDAY(a)+1;
SET @wx1 = 8-@w1;
IF @w1>5 THEN
SET @w1 = 0;
ELSE
SET @w1 = 6-@w1;
END IF;
 
SET @wx2 = WEEKDAY(b)+1;
SET @w2 = @wx2;
IF @w2>5 THEN
SET @w2 = 5;
END IF;
 
SET @weeks = (@x-@wx1-@wx2)/7;
SET @noweekends = (@weeks*5)+@w1+@w2;
 
SET @result = @noweekends-freedays;
RETURN @result*@m;
END $$
/*!50003 SET SESSION SQL_MODE=@TEMP_SQL_MODE */  $$

DELIMITER ;



/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
